; Assembly Source File
; Created 25/05/2004, 01:51:19
	include "utsr_types.h" 
	include "tios.h"
	include "utsr_events.h"
;	include "Conf Lib.h"
; include "kernel.h"
    xdef   _main
    xdef   _ti89
    xdef   _ti92plus
    xdef   _v200
    xdef   _ti89ti
	DEFINE	_version01
 
_main:
 movem.l a0-a6/d0-d7,-(a7)
 move.l  200,a5
;******************************
; initialisation du TSR
;******************************
 move.l  $90,_tsr_faskbd4_reloc_1+2

 lea     key_2(pc),a2
 lea     OSInitBetweenKeyDelay(pc),a3
 bsr     install_key
 lea     OSInitKeyInitDelay(pc),a3
 lea     key_1(pc),a2
 bsr     install_key
 lea     Reload_key(pc),a3
 lea     key_3(pc),a2
 bsr     install_key
 bsr     load_values

 pea     kernel::SystemDir
 pea     format_reload_str(pc)
 pea     reload_str(pc)
 move.l  $53*4(a5),a0
 jsr     (a0)
 pea     kernel::SystemDir
 pea     format_help_str(pc)
 pea     help_str(pc)
 move.l  $53*4(a5),a0
 jsr     (a0)
 lea     24(a7),a7
;******************************
;installation du TSR
;******************************
 move.w  #UTSR_AUTHORIZE_DLG,-(a7)
 pea     data_tsr(pc)
 move.w  #2,-(a7); 2 fonctions 
 move.l  #_tsr_faskbd4_end-_tsr_faskbd4_beginning,d0
 move.l  d0,-(a7)
 pea     _tsr_faskbd4_beginning(pc)
 jsr     utsrlib@0000
 lea     16(a7),a7
 movem.l (a7)+,a0-a6/d0-d7
 rts
 
install_key:
 clr.l   -(a7);error pointer
 moveq   #0,d0
 move.w  (a3),d0
 move.l  d0,-(a7)
 move.l  a2,-(a7)
 pea     section(pc)
 pea     file(pc)
 jsr     conflib@0000
 move.l  d0,-(a7)
 move.l  a2,-(a7)
 pea     section(pc)
 pea     file(pc)
 jsr     conflib@0001
 lea     36(a7),a7
 move.w  d0,(a3)
 rts

_tsr_faskbd4_beginning:
_tsr_faskbd4:
 dc.b    'FastKbd4'
_tsr_faskbd4_id:
 dc.w    0
_tsr_faskbd4_hook:
 move.l  4(a7),a0
 move.w  2(a0),d0
 move.w  _tsr_faskbd4_id(pc),d1
 cmp.w   #UTSR_FORMAT,(a0)
 bne     \skip_format
 cmp.w   #-1,d0
 beq     \ok
 cmp.w   d0,d1
 bne     \skip_format
\ok:
 move.l  #$00010004,-(a7)
 pea     reload_str(pc)
 pea     title_str(pc)
 move.l  200,a0
 move.l  $1B4*4(a0),a0;DlgMessage
 jsr     (a0)
 lea     12(a7),a7
 cmp.w   #13,d0
 bne     \skip_format
\reload:
 lea     OSInitKeyInitDelay(pc),a3
 lea     key_1(pc),a2
 bsr     _reload
 lea     OSInitBetweenKeyDelay(pc),a3
 lea     key_2(pc),a2
 bsr     _reload
 lea     Reload_key(pc),a3
 lea     key_3(pc),a2
 bsr     _reload
 bsr     load_values
 rts
\skip_format:
 cmp.w   #UTSR_RELOAD,(a0)
 bne     \skip_reload
 cmp.w   #-1,d0
 beq     \reload
 cmp.w   d0,d1
 beq     \reload
\skip_reload:
 cmp.w   #UTSR_HELP,(a0)
 bne     \skip_help
 cmp.w   d0,d1
 bne     \skip_help
 lea     help_str(pc),a1
 move.l  a1,8(a0) 
\skip_help:
 move.w  Reload_key(pc),d0
 beq     \skip_key
 cmp.w   #UTSR_ICON,(a0)
 bne     \skip_key
 cmp.w   10(a0),d0
 bne     \skip_key
 bsr     load_values
\skip_key: 
 rts

_reload:
 movem.l a3/a2,-(a7)
 clr.l   -(a7);error pointer
 moveq   #0,d0
 move.w  (a3),d0
 move.l  d0,-(a7)
 move.l  a2,-(a7)
 pea     section(pc)
 pea     file(pc)
 clr.l   -(a7)
 pea     conflib_str(pc)
 jsr     kernel::LibsExec
 tst.l   (a7)
 lea     28(a7),a7
 beq     \error
 move.w  d0,(a3)
\error:
 movem.l (a7)+,a3-a2
 rts

_tsr_faskbd4_trap4:
 pea     _tsr_faskbd4_restore(pc)
 clr.w   -(a7)
_tsr_faskbd4_reloc_1:
 jmp.l   $123456
_tsr_faskbd4_restore:
 movem.l a0-a1/d0-d2,-(a7)
 bsr     load_values
 movem.l (a7)+,d0-d2/a0-a1
 trap    #12
 rte
load_values:
 move.l  OSInitBetweenKeyDelay(pc),-(a7)
 jsr     tios::OSInitBetweenKeyDelay
 addq.l  #2,a7
 jsr     tios::OSInitKeyInitDelay
 addq.l  #2,a7
 rts
OSInitBetweenKeyDelay:
 dc.w    $C8
OSInitKeyInitDelay:
 dc.w    $14
Reload_key:
 dc.w    0
reload_str:
 dc.b  'Reload %system\utsr [FastKbd4] ?  ',0
title_str:
 dc.b  'FastKbd 4 1.00',0
conflib_str:
 dc.b    'conflib',0
help_str:
 dc.b    'You can change settings in ',10,'%system\utsr [FastKbd4]  ',0
key_1:
 dc.b    'OSInitKeyInitDelay',0
key_2:
 dc.b    'OSInitBetweenKeyDelay',0
key_3:
 dc.b    'Reload_key',0
section:
 dc.b    'FastKBD4',0
file:
 dc.b    'utsr',0,0,0,0
 even
_tsr_faskbd4_end:
data_tsr:
 dc.w     UTSR_UNKNOWN,_tsr_faskbd4_trap4-_tsr_faskbd4,$0,$90
 dc.w     UTSR_EV_HOOK,_tsr_faskbd4_hook-_tsr_faskbd4
format_reload_str:
 dc.b  'Reload %s\utsr [FastKbd4] ?',0
format_help_str:
 dc.b    'You can change settings in ',10,'%s\utsr [FastKbd4]',0
 even